/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal;

import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GlassBlock;
import net.minecraft.world.level.block.StainedGlassBlock;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.platform_specific.IPRegistry;
import qouteall.imm_ptl.core.portal.GeometryPortalShape;
import qouteall.imm_ptl.core.portal.Mirror;
import qouteall.imm_ptl.core.portal.nether_portal.BlockPortalShape;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.IntBox;

public class BreakableMirror
extends Mirror {
    @Nullable
    public IntBox wallArea;
    @Nullable
    public BlockPortalShape blockPortalShape;
    public boolean unbreakable = false;

    public BreakableMirror(EntityType<?> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    protected void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.wallArea = tag.m_128441_("boxXL") ? new IntBox(new BlockPos(tag.m_128451_("boxXL"), tag.m_128451_("boxYL"), tag.m_128451_("boxZL")), new BlockPos(tag.m_128451_("boxXH"), tag.m_128451_("boxYH"), tag.m_128451_("boxZH"))) : null;
        this.blockPortalShape = tag.m_128441_("blockPortalShape") ? BlockPortalShape.fromTag(tag.m_128469_("blockPortalShape")) : null;
        if (tag.m_128441_("unbreakable")) {
            this.unbreakable = tag.m_128471_("unbreakable");
        }
    }

    @Override
    protected void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        if (this.wallArea != null) {
            tag.m_128405_("boxXL", this.wallArea.l.m_123341_());
            tag.m_128405_("boxYL", this.wallArea.l.m_123342_());
            tag.m_128405_("boxZL", this.wallArea.l.m_123343_());
            tag.m_128405_("boxXH", this.wallArea.h.m_123341_());
            tag.m_128405_("boxYH", this.wallArea.h.m_123342_());
            tag.m_128405_("boxZH", this.wallArea.h.m_123343_());
        }
        if (this.blockPortalShape != null) {
            tag.m_128365_("blockPortalShape", (Tag)this.blockPortalShape.toTag());
        }
        tag.m_128379_("unbreakable", this.unbreakable);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && !this.unbreakable && this.m_9236_().m_46467_() % 10L == (long)(this.m_19879_() % 10)) {
            this.checkWallIntegrity();
        }
    }

    @Override
    public boolean isPortalValid() {
        return super.isPortalValid() && (this.wallArea != null || this.blockPortalShape != null);
    }

    private void checkWallIntegrity() {
        boolean wallValid = this.wallArea != null ? this.wallArea.fastStream().allMatch(blockPos -> BreakableMirror.isGlass(this.m_9236_(), blockPos)) : (this.blockPortalShape != null ? this.blockPortalShape.area.stream().allMatch(blockPos -> BreakableMirror.isGlass(this.m_9236_(), blockPos)) : false);
        if (!wallValid) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public static boolean isGlass(Level world, BlockPos blockPos) {
        Block block = world.m_8055_(blockPos).m_60734_();
        return block instanceof GlassBlock || block == Blocks.f_50185_ || block instanceof StainedGlassBlock || block instanceof StainedGlassPaneBlock;
    }

    private static boolean isGlassPane(Level world, BlockPos blockPos) {
        Block block = world.m_8055_(blockPos).m_60734_();
        return block == Blocks.f_50185_ || block instanceof StainedGlassPaneBlock;
    }

    public static BreakableMirror createMirror(ServerLevel world, BlockPos glassPos, Direction facing) {
        if (!BreakableMirror.isGlass((Level)world, glassPos)) {
            return null;
        }
        boolean isPane = BreakableMirror.isGlassPane((Level)world, glassPos);
        if (facing.m_122434_() == Direction.Axis.Y && isPane) {
            return null;
        }
        Predicate<BlockPos> glassWallPredicate = blockPos -> BreakableMirror.isGlass((Level)world, blockPos) && isPane == BreakableMirror.isGlassPane((Level)world, blockPos) && world.m_8055_(blockPos.m_121945_(facing)).m_60795_();
        BlockPortalShape shape = BlockPortalShape.findArea(glassPos, facing.m_122434_(), glassWallPredicate, blockPos -> !glassWallPredicate.test((BlockPos)blockPos));
        if (shape == null) {
            return null;
        }
        BreakableMirror breakableMirror = (BreakableMirror)((EntityType)IPRegistry.BREAKABLE_MIRROR.get()).m_20615_((Level)world);
        assert (breakableMirror != null);
        double distanceToCenter = isPane ? 0.0625 : 0.5;
        breakableMirror.blockPortalShape = shape;
        AABB wallBox = McHelper.getWallBox((Level)world, shape.area.stream());
        if (wallBox == null) {
            return null;
        }
        Vec3 pos = Helper.getBoxSurfaceInversed(wallBox, facing.m_122424_()).m_82399_();
        pos = Helper.putCoordinate(pos, facing.m_122434_(), Helper.getCoordinate(shape.innerAreaBox.getCenterVec().m_82549_(Vec3.m_82528_((Vec3i)facing.m_122436_()).m_82490_(distanceToCenter)), facing.m_122434_()));
        breakableMirror.m_6034_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        breakableMirror.setDestination(pos);
        breakableMirror.dimensionTo = world.m_46472_();
        Tuple<Direction, Direction> perpendicularDirections = Helper.getPerpendicularDirections(facing);
        Direction wDirection = (Direction)perpendicularDirections.m_14418_();
        Direction hDirection = (Direction)perpendicularDirections.m_14419_();
        breakableMirror.width = Helper.getCoordinate(Helper.getBoxSize(wallBox), wDirection.m_122434_());
        breakableMirror.height = Helper.getCoordinate(Helper.getBoxSize(wallBox), hDirection.m_122434_());
        breakableMirror.axisW = Vec3.m_82528_((Vec3i)wDirection.m_122436_());
        breakableMirror.axisH = Vec3.m_82528_((Vec3i)hDirection.m_122436_());
        BreakableMirror.initializeMirrorGeometryShape(breakableMirror, facing, shape);
        BreakableMirror.breakIntersectedMirror(breakableMirror);
        world.m_7967_((Entity)breakableMirror);
        return breakableMirror;
    }

    private static void initializeMirrorGeometryShape(BreakableMirror breakableMirror, Direction facing, BlockPortalShape shape) {
        if (shape.isRectangle()) {
            breakableMirror.specialShape = null;
            return;
        }
        Vec3 center = breakableMirror.getOriginPos();
        Level world = breakableMirror.m_9236_();
        Vec3 axisW = breakableMirror.axisW;
        Vec3 axisH = breakableMirror.axisH;
        GeometryPortalShape geometryPortalShape = new GeometryPortalShape();
        for (BlockPos blockPos : shape.area) {
            VoxelShape collisionShape = world.m_8055_(blockPos).m_60812_((BlockGetter)world, blockPos);
            if (collisionShape.m_83281_()) continue;
            AABB bounds = collisionShape.m_83215_().m_82383_(Vec3.m_82528_((Vec3i)blockPos));
            Vec3 p1 = new Vec3(bounds.f_82288_, bounds.f_82289_, bounds.f_82290_);
            Vec3 p2 = new Vec3(bounds.f_82291_, bounds.f_82292_, bounds.f_82293_);
            double p1LocalX = p1.m_82546_(center).m_82526_(axisW);
            double p1LocalY = p1.m_82546_(center).m_82526_(axisH);
            double p2LocalX = p2.m_82546_(center).m_82526_(axisW);
            double p2LocalY = p2.m_82546_(center).m_82526_(axisH);
            geometryPortalShape.addTriangleForRectangle(p1LocalX, p1LocalY, p2LocalX, p2LocalY);
        }
        breakableMirror.specialShape = geometryPortalShape;
    }

    public IntBox getAreaBox() {
        if (this.wallArea != null) {
            return this.wallArea;
        }
        if (this.blockPortalShape != null) {
            return this.blockPortalShape.innerAreaBox;
        }
        throw new RuntimeException();
    }

    private static void breakIntersectedMirror(BreakableMirror newMirror) {
        McHelper.getEntitiesNearby(newMirror, BreakableMirror.class, IPGlobal.maxNormalPortalRadius).stream().filter(mirror1 -> mirror1.getNormal().m_82526_(newMirror.getNormal()) > 0.5).filter(mirror1 -> IntBox.getIntersect(mirror1.getAreaBox(), newMirror.getAreaBox()) != null).filter(mirror -> mirror != newMirror).forEach(e -> e.m_142687_(Entity.RemovalReason.KILLED));
    }
}

